/*
 * Decompiled with CFR 0.152.
 */
package catbop.catbopthings.modifiers;

import catbop.catbopthings.CatbopThings;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class CraftedModifier
extends Modifier
implements ConditionalStatModifierHook {
    private static final Component MINING_SPEED = new TranslatableComponent(Util.m_137492_((String)"modifier", (ResourceLocation)CatbopThings.id("crafted.mining_speed")));
    private static final Component VELOCITY = new TranslatableComponent(Util.m_137492_((String)"modifier", (ResourceLocation)CatbopThings.id("crafted.velocity")));
    private static final Component ATTACK_DAMAGE = new TranslatableComponent(Util.m_137492_((String)"modifier", (ResourceLocation)CatbopThings.id("crafted.damage")));
    private static final float MINING_AT_FULL = 2.0f;
    private static final float MIN_BOOST_PERCENT = 0.5f;
    private static final float VELOCITY_AT_FULL = 0.05f;
    private static final float DAMAGE_AT_FULL = 1.333f;

    private static float getTotalBoost(IToolStackView tool, int level) {
        int max;
        float min;
        int durability = tool.getCurrentDurability();
        if ((float)durability > (min = (float)(max = tool.getStats().getInt((IToolStat)ToolStats.DURABILITY)) * 0.5f)) {
            return (float)level * ((float)durability - min) / ((float)max - min);
        }
        return 0.0f;
    }

    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, TinkerHooks.CONDITIONAL_STAT);
    }

    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
        if (harvest || tool.hasTag(TinkerTags.Items.RANGED)) {
            double boost = level;
            if (tooltipKey == TooltipKey.SHIFT) {
                boost = CraftedModifier.getTotalBoost(tool, level);
            }
            if (boost > (double)0.01f) {
                if (harvest) {
                    this.addFlatBoost(MINING_SPEED, boost * 2.0 * (double)tool.getMultiplier((INumericToolStat)ToolStats.MINING_SPEED), tooltip);
                    this.addFlatBoost(ATTACK_DAMAGE, boost * (double)1.333f * (double)tool.getMultiplier((INumericToolStat)ToolStats.ATTACK_DAMAGE), tooltip);
                } else {
                    this.addFlatBoost(VELOCITY, boost * (double)0.05f * (double)tool.getMultiplier((INumericToolStat)ToolStats.VELOCITY), tooltip);
                }
            }
        }
    }

    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (isEffective) {
            event.setNewSpeed(event.getNewSpeed() + 2.0f * CraftedModifier.getTotalBoost(tool, level) * miningSpeedModifier * tool.getMultiplier((INumericToolStat)ToolStats.MINING_SPEED));
        }
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        if (stat == ToolStats.VELOCITY) {
            baseValue += 0.05f * CraftedModifier.getTotalBoost(tool, modifier.getLevel()) * multiplier;
        }
        if (stat == ToolStats.ATTACK_DAMAGE) {
            baseValue += 1.333f * CraftedModifier.getTotalBoost(tool, modifier.getLevel()) * multiplier;
        }
        return baseValue;
    }
}

